$Title:(10) Adjust for zero levels in h, q, w

*       ----------------------------------------------------------------       *
*                                                                              *
*                   Global Trade Analysis Project                              *
*                       GTAP Water database                                    *
*            (10) Adjust for zero levels in h, q, w                            *
*                                                                              *
*       ----------------------------------------------------------------       *

* GTAP assumes small value for production even if there is no production.
* To make volume data consiistent with GTAP tradition, adjustment is required.

parameter adj_flag adjusted for zero production and area if equals 1 /0/

If(adj_flag = 1,
         VOLUME('HI',a,b,c,r)$(vfm_('IrrLand',a,b,c,r) and not HI(a,b,c,r))
         = 0.0001*vfm_('IrrLand',a,b,c,r) /
           sum((aez,rb),vfm_('IrrLand',aez,rb,c,r));

         VOLUME('QI',a,b,c,r)$(vfm_('IrrLand',a,b,c,r) and not QI(a,b,c,r))
         = 0.0010*vfm_('IrrLand',a,b,c,r) /
           sum((aez,rb),vfm_('IrrLand',aez,rb,c,r));

         VOLUME('HR',a,b,c,r)$(vfm_('RfdLand',a,b,c,r) and not HR(a,b,c,r))
         = 0.0001*vfm_('RfdLand',a,b,c,r) /
           sum((aez,rb),vfm_('RfdLand',aez,rb,c,r));

         VOLUME('QR',a,b,c,r)$(vfm_('RfdLand',a,b,c,r) and not QR(a,b,c,r))
         = 0.0010*vfm_('RfdLand',a,b,c,r) /
           sum((aez,rb),vfm_('RfdLand',aez,rb,c,r));

         VOLUME('WW',a,b,c,r)$(vfm_('Water',a,b,c,r) and not HI(a,b,c,r))
         = 0.0100* vfm_('Water',a,b,c,r) /
           sum((aez,rb),vfm_('Water',aez,rb,c,r));
         display '*** ------------------------------- ***'
         display ' *** Warning: Database is adjusted ***'
         display '*** ------------------------------- ***';
         );
